clear
set more off

****************************************************************************
* Replace this next line with the directory where you've saved the files
****************************************************************************
*cd "C:\Documents and Settings\Ian\My Documents\PAE - Schools\Data\Publish"
cd "C:\Users\Andrew\My publications\Aust - house prices & school quality\For Replication"

use ACT_BoundaryALL_Final 

**SUMMARY STATISTICS
xi: regress logprice uai i.saleqy logblksize, robust 
sum price logprice logblksize beds bath park distance uai lnmedwkinc overseasborn 
sum price logprice logblksize beds bath park distance uai medwkinc lnmedwkinc overseasborn if e(sample), sep(0)

***RESULTS 
**MAIN SPECS 
xi: regress logprice uai i.saleqy logblksize, robust 
xi: regress logprice uai i.saleqy i.boundary logblksize, robust 
xi: regress logprice uai i.saleqy i.boundary logblksize logblksize_squd logblksize_cbd i.beds, robust 
xi: regress logprice uai i.boundary i.saleqy logblksize logblksize_squd logblksize_cbd i.beds i.bath, robust 
xi: regress logprice uai i.boundary i.saleqy logblksize logblksize_squd logblksize_cbd i.beds i.bath i.park, robust 
test  logblksize  logblksize_squd logblksize_cbd 

***ROBUSTNESS CHECKS 

**ALL 
xi: regress logprice uai i.saleqy i.boundary logblksize, robust 

**  test of weight 
xi: regress logprice uai i.boundary i.saleqy logblksize logblksize_squd logblksize_cbd i.beds i.bath i.park [aw=weight], robust 

**DISTANCE FROM BOUNDARY 
xi: regress logprice uai i.saleqy i.boundary logblksize if distance<=500, robust 
xi: regress logprice uai i.saleqy i.boundary logblksize if distance<=200, robust 
for num 200(100)600: xi: regress logprice uai i.saleqy i.boundary logblksize if distance<=X, robust 

***ADD DEMOGRAPHIC CONTROLS 

** overseasborn 
xi: regress logprice uai i.boundary i.saleqy logblksize overseasborn, robust 

** overseasborn + lnmedian income 
xi: regress logprice uai i.boundary i.saleqy logblksize overseasborn lnmedwkinc, robust 


**DISSAGGREGATE BY NO OF BEDROOMS 

**Actual no of bedrooms 
gen beds3=1 if beds<=3 
replace beds3=0 if beds>=4 & beds~=. 
gen beds4=1 if beds>=4 & beds~=. 
replace beds4=0 if beds<=3 
gen uai_beds3=uai*beds3 
gen uai_beds4=uai*beds4 
xi: reg logprice uai_beds3 uai_beds4 i.beds i.boundary i.saleqy logblksize , robust 
test uai_beds3=uai_beds4 

**Predicted no of bedrooms 
gen beds_hat3=1 if beds_hat<=3 
replace beds_hat3=0 if beds_hat>3 & beds_hat~=. 
gen beds_hat4=1 if beds_hat>=4 & beds_hat~=. 
replace beds_hat4=0 if beds_hat<4 
gen uai_beds_hat3=uai*beds_hat3 
gen uai_beds_hat4=uai*beds_hat4 
xi: reg logprice uai_beds_hat3 uai_beds_hat4 i.boundary i.beds_hat i.saleqy logblksize , robust 
test uai_beds_hat3=uai_beds_hat4 

**USE MEAN UAI OVER TIME (as opposed to previous years UAI) 

gen mean_uai=. 

replace mean_uai=80.2 if school=="Copeland" & saleyear==2005 
replace mean_uai=78.1 if school=="Copeland" & saleyear==2004 
replace mean_uai=80.35 if school=="Copeland" & saleyear==2003 

replace mean_uai=73.8 if school=="Canberra" & saleyear==2005 
replace mean_uai=75.8 if school=="Canberra" & saleyear==2004 
replace mean_uai=77.05 if school=="Canberra" & saleyear==2003 

replace mean_uai=78.9 if school=="Dickson" & saleyear==2005 
replace mean_uai=74 if school=="Dickson" & saleyear==2004 
replace mean_uai=67.5 if school=="Dickson" & saleyear==2003 

replace mean_uai=73.5 if school=="Erindale" & saleyear==2005 
replace mean_uai=73.8 if school=="Erindale" & saleyear==2004 
replace mean_uai=73.03 if school=="Erindale" & saleyear==2003 

replace mean_uai=74.1 if school=="Hawker" & saleyear==2005 
replace mean_uai=74.9 if school=="Hawker" & saleyear==2004 
replace mean_uai=72.7 if school=="Hawker" & saleyear==2003 

replace mean_uai=68.25 if school=="Lginn" & saleyear==2005 
replace mean_uai=69.7 if school=="Lginn" & saleyear==2004 
replace mean_uai=69.7 if school=="Lginn" & saleyear==2003 

replace mean_uai=72.9 if school=="Ltugg" & saleyear==2005 
replace mean_uai=70.7 if school=="Ltugg" & saleyear==2004 
replace mean_uai=72.85 if school=="Ltugg" & saleyear==2003 

replace mean_uai=84.5 if school=="Narrabundah" & saleyear==2005 
replace mean_uai=85.4 if school=="Narrabundah" & saleyear==2004 
replace mean_uai=85.25 if school=="Narrabundah" & saleyear==2003  

xi: regress logprice mean_uai i.boundary i.saleqy logblksize, robust 

***FURTHER ROBUSTNESS CHECKS (not shown in paper)

* Differencing
xi: regress logprice uai i.saleqy i.boundary logblksize, robust 
outreg using results.doc, coefastr se nocons bracket 3aster replace ct("Differencing") bdec(3)
bysort boundary: egen temp1=mean(logprice) if e(sample)
gen dlogprice=logprice-temp1 if e(sample)
bysort boundary: egen temp2=mean(uai) if e(sample)
gen duai=uai-temp2 if e(sample)
drop temp*
xi: regress dlogprice uai i.saleqy logblksize, robust 
outreg using results.doc, coefastr se nocons bracket 3aster append ct("Differencing") bdec(3)
regress dlogprice uai , robust 
outreg using results.doc, coefastr se nocons bracket 3aster append ct("Differencing") bdec(3)
xi: regress dlogprice duai i.saleqy logblksize, robust 
outreg using results.doc, coefastr se nocons bracket 3aster append ct("Differencing") bdec(3)
regress dlogprice duai , robust 
outreg using results.doc, coefastr se nocons bracket 3aster append ct("Differencing") bdec(3)

* Matching
bysort boundary: egen temp1=max(uai)
bysort boundary: egen temp2=min(uai)
gen group=1 if uai==temp1
replace group=0 if uai==temp2
gen pscorewgt=.
for num 1/6: xi: psmatch2 group logblksize i.beds if boundary==X, llr outcome(logprice) \ replace pscorewgt=1/_pscore if boundary==X
xi: reg logprice uai i.boundary [aw=pscorewgt]
outreg using results.doc, coefastr se nocons bracket 3aster append ct("Matching") bdec(3)

xi: psmatch2 group logblksize logblksize_squd logblksize_cbd i.beds i.bath i.park i.saleqy, llr outcome(logprice)
replace pscorewgt=1/_pscore 
xi: reg logprice uai i.boundary [aw=pscorewgt]
outreg using results.doc, coefastr se nocons bracket 3aster append ct("Matching") bdec(3)
*xi: psmatch2 group logblksize i.saleqy, llr outcome(logprice)
*replace pscorewgt=1/_pscore 
*xi: reg logprice uai i.boundary [aw=pscorewgt]
*outreg using results.doc, coefastr se nocons bracket 3aster append ct("Matching") bdec(3)

***SCHOOL FIXED EFFECTS (doesn't work, since the within-school UAI variation is mostly noise)
xi: regress logprice uai i.school i.saleqy i.boundary logblksize , robust 

* Distance from boundary interaction
xi: regress logprice uai distance i.saleqy i.boundary logblksize , robust 
egen dist=std(distance) if e(sample)
gen uai_dist=uai*dist
xi: regress logprice uai uai_dist dist i.saleqy i.boundary logblksize , robust 

**Bootstrapping standard errors to take account of the generated regressor problem.
tempfile temp
capture program drop boot
program define boot, eclass
	drop beds_hat beds_hat3 beds_hat4 uai_bed*
	xi: reg beds blksize if boundary==1
	predict beds_hat1 if boundary==1
	gen beds_hat=beds_hat1
	xi: reg beds blksize if boundary==2
	predict beds_hat2 if boundary==2
	replace beds_hat=beds_hat2 if beds_hat==.
	xi: reg beds blksize if boundary==3
	predict beds_hat3 if boundary==3
	replace beds_hat=beds_hat3 if beds_hat==.
	xi: reg beds blksize if boundary==4
	predict beds_hat4 if boundary==4
	replace beds_hat=beds_hat4 if beds_hat==.
	xi: reg beds blksize if boundary==5
	predict beds_hat5 if boundary==5
	replace beds_hat=beds_hat5 if beds_hat==.
	xi: reg beds blksize if boundary==6
	predict beds_hat6 if boundary==6
	replace beds_hat=beds_hat6 if beds_hat==.
	replace beds_hat=beds if beds~=.
	drop beds_hat1 beds_hat2 beds_hat3 beds_hat4 beds_hat5 beds_hat6
	recode beds_hat min/2.49=2 2.50/3.4999=3 3.50/4.49=4 4.50/5.49=5 5.50/6.49=6 6.50/max=7 .=. 
	gen beds_hat3=1 if beds_hat<=3 
	replace beds_hat3=0 if beds_hat>3 & beds_hat~=. 
	gen beds_hat4=1 if beds_hat>=4 & beds_hat~=. 
	replace beds_hat4=0 if beds_hat<4 
	gen uai_beds_hat3=uai*beds_hat3 
	gen uai_beds_hat4=uai*beds_hat4 
	xi: reg logprice uai_beds_hat3 uai_beds_hat4 i.boundary i.beds_hat i.saleqy logblksize , robust 
	matrix b = e(b)
	matrix V = e(V)
	ereturn post b V
	test uai_beds_hat3=uai_beds_hat4 
end
boot
bootstrap boot _b, reps(1000) saving(`temp')
use `temp', clear
hist b_uai_beds_hat3, normal
hist b_uai_beds_hat4, normal


